#include "REG_MG84FL54.H"
#include "Define.H"
#include "Timer0.H"


BIT OutFlag;
BYTE PinStatus[5];
BYTE T0Cnt; 


void INT_TIMER0(void) interrupt 1 using 2        // Timer0 Interrupt
  { TR0 = CLR;                                   // Disable Timer0
    
    
    if ( T0Cnt )
      { T0Cnt--;
      }
    else
      { PinStatus[0] = P0;
        PinStatus[1] = P1;
        PinStatus[2] = P2;
        PinStatus[3] = P3;
        PinStatus[4] = P4;
        
        OutFlag = SET;                           // Will trigger " USB_Send_Data_To_PC(); "
        
        T0Cnt = TIMEMAX;
      }
    
    TL0 = T0_1MSL;
    TH0 = T0_1MSH;
    TR0 = SET;                                   // Enable Timer0
  }


void Initial_Timer0( void )
  { IP = 0x02;	                                 // hi priority: Timer0
    
    TMOD = 0x01;                                 // Set Timer0 at Mode1 ( 16 bit )
    TR0 = 0;                                     // Desable Timer0
    ET0 = 1;                                     // Enable Timer0 interrupt
    
    T0Cnt = TIMEMAX;                             // 
    TL0 = T0_1MSL;                               // 
    TH0 = T0_1MSH;                               // 
    TR0 = SET;                                   // Enable Timer0
    
    OutFlag = CLR;
  }